<?php
    include("datos_sistema.php");
    /*error_reporting(E_ALL);
    ini_set('display_errors', 1);*/
    $sqlcountalumnos = "SELECT * FROM habitaciones WHERE estado='Activo'";
    $querycountalumnos = mysqli_query($con, $sqlcountalumnos);
    $countalumnos = mysqli_num_rows($querycountalumnos);

    //TOTAL CLIENTES
    $sqlcountapoderados = "SELECT * FROM reservas WHERE estado='Activo'";
    $querycountapoderados = mysqli_query($con, $sqlcountapoderados);
    $countapoderados = mysqli_num_rows($querycountapoderados);

    $sqlmatriculas = "SELECT * FROM usuario WHERE estado='Activo' AND rol='Cliente'";
    $querymatriculas = mysqli_query($con, $sqlmatriculas);
    $total_matriculas = mysqli_num_rows($querymatriculas);
    //$total_matriculas = number_format($total_matriculas, 0, '', '.');


    $sqlingresos = "SELECT SUM(CAST(REPLACE(total, '.', '') AS UNSIGNED)) AS total_ingresos FROM reservas WHERE estado='Activo' AND estado_reserva = 'Pagado Online'";
    $queryingresos = mysqli_query($con, $sqlingresos);
    $row_ingresos = mysqli_fetch_assoc($queryingresos);
    $total_ingresos = $row_ingresos['total_ingresos'];
    $total_ingresos = number_format($total_ingresos, 0, '', '.');

    //TOTAL MATRICULAS INGRESOS
    /*$sqlmatriculas = "SELECT SUM(REPLACE(abono, '.', '')) AS total_suma FROM matriculas WHERE estado='Activo'";
    $querymatriculas = mysqli_query($con, $sqlmatriculas);
    $row_matric = mysqli_fetch_assoc($querymatriculas);
    $total_matriculas = $row_matric['total_suma'];
    $total_matriculas = number_format($total_matriculas, 0, '', '.');*/

    // Consulta SQL
    $sql10ingresosmayores = "
        SELECT 
            h.nombre_habitacion, 
            r.numero, 
            SUM(REPLACE(r.total, '.', '')) AS total_ingresos 
        FROM 
            reservas r
        JOIN 
            habitaciones h ON r.id_habitacion = h.id_habitacion 
        WHERE
            r.estado = 'Activo'
        GROUP BY 
            r.id_habitacion, r.numero
        ORDER BY 
            total_ingresos DESC
        LIMIT 10
    ";


    $query = $con->query($sql10ingresosmayores);

    // TOTAL MENSUALIDAD INGRESOS
    $sqlmensualidad = "
        SELECT SUM(
            CASE 
                WHEN monto_editado = 'No' THEN REPLACE(monto_mensualidad, '.', '')
                WHEN monto_editado = 'Si' THEN nuevo_monto
                ELSE 0
            END
        ) AS total_suma 
        FROM mensualidades 
        WHERE estado = 'Activo'";
        
    $querymensualidad = mysqli_query($con, $sqlmensualidad);
    $row_mensualidad = mysqli_fetch_assoc($querymensualidad);
    $total_mensualidades = $row_mensualidad['total_suma'];
    $total_mensualidades = number_format($total_mensualidades, 0, '', '.');

    //TOTAL INGRESOS POR NIVEL
    $sqlmensualidad_nivel = "
        SELECT a.nivel_estudio, 
               SUM(
                   CASE 
                       WHEN m.monto_editado = 'No' THEN REPLACE(m.monto_mensualidad, '.', '')
                       WHEN m.monto_editado = 'Si' THEN m.nuevo_monto
                       ELSE 0
                   END
               ) AS total_mensualidad_nivel
        FROM mensualidades m
        INNER JOIN alumnos a ON m.id_alumno = a.id_alumno
        WHERE m.estado = 'Activo'
        GROUP BY a.nivel_estudio
        ORDER BY total_mensualidad_nivel DESC";
    $querymensualidad_nivel = mysqli_query($con, $sqlmensualidad_nivel);

    //CALCULO DE GRAFICO DE GANANCIAS INGRESOS ANUAL 
    // Obtener el año actual
    $current_year = date('Y');
    // Consulta SQL para obtener la suma total por mes del último año
    $sql_ventas_meses = "SELECT
                DATE_FORMAT(fecha_registro, '%Y-%m') AS mes,
                SUM(CAST(REPLACE(total, '.', '') AS UNSIGNED)) AS total_mes
            FROM
                reservas
            WHERE
                YEAR(fecha_registro) = $current_year
                AND estado_reserva = 'Pagado Online' AND estado = 'Activo' or YEAR(fecha_registro) = $current_year
                AND estado_reserva = 'Completado' AND estado = 'Activo' or YEAR(fecha_registro) = $current_year
                AND estado_reserva = 'Finalizado'
                AND estado = 'Activo'
            GROUP BY
                DATE_FORMAT(fecha_registro, '%Y-%m')
            ORDER BY
                DATE_FORMAT(fecha_registro, '%Y-%m')";
    $result_ventas_meses = $con->query($sql_ventas_meses);
    // Verificar si hubo un error en la consulta
    if (!$result_ventas_meses) {
        die("Error en la consulta: " . $con->error);
    }
    // Inicializar un array para almacenar los totales por mes
    $totales_por_mes = array();
    // Procesar el resultado de la consulta
    if ($result_ventas_meses->num_rows > 0) {
        while($row_meses = $result_ventas_meses->fetch_assoc()) {
            // El total ya está limpiado en la consulta SQL, así que no es necesario hacer más transformaciones en PHP
            $total_mes = $row_meses['total_mes'];
            // Almacenar el total en el array con el mes como clave
            $totales_por_mes[$row_meses['mes']] = $total_mes;
        }
    } else {
        echo "0 results";
    }

    //SQLS PARA 
    $current_year = date('Y');
    $sql_esporadicos = "SELECT SUM(CAST(REPLACE(total, '.', '') AS UNSIGNED)) AS total_esporadicos
                        FROM reservas r
                        INNER JOIN usuario u ON r.id_usuario = u.id_usuario
                        WHERE YEAR(r.fecha_registro) = $current_year
                        AND r.estado_reserva IN ('Pagado Online', 'Finalizado', 'Completado')
                        AND u.tipo_usuario = 'Esporádico' AND r.estado = 'Activo'";

    $result_esporadicos = $con->query($sql_esporadicos);
    $total_esporadicos = $result_esporadicos->fetch_assoc()['total_esporadicos'] ?? 0;

    // Consulta para Empresas
    $sql_empresas = "SELECT SUM(CAST(REPLACE(r.total, '.', '') AS UNSIGNED)) AS total_empresas
                     FROM reservas r
                     INNER JOIN usuario u ON r.id_usuario = u.id_usuario
                     WHERE YEAR(r.fecha_registro) = $current_year
                     AND r.estado_reserva IN ('Pagado Online', 'Finalizado', 'Completado')
                     AND u.tipo_usuario = 'Empresa' AND r.estado = 'Activo'";
    $result_empresas = $con->query($sql_empresas);
    $total_empresas = $result_empresas->fetch_assoc()['total_empresas'] ?? 0;
    // Consulta para Turistas
    $sql_turistas = "SELECT SUM(CAST(REPLACE(r.total, '.', '') AS UNSIGNED)) AS total_turistas
                     FROM reservas r
                     INNER JOIN usuario u ON r.id_usuario = u.id_usuario
                     WHERE YEAR(r.fecha_registro) = $current_year
                     AND r.estado_reserva IN ('Pagado Online', 'Finalizado', 'Completado')
                     AND u.tipo_usuario = 'Turista' AND r.estado = 'Activo'";
    $result_turistas = $con->query($sql_turistas);
    $total_turistas = $result_turistas->fetch_assoc()['total_turistas'] ?? 0;




    //SQL PARA INGRESOS POR ESTACION DE AÑO:
    $current_year = date('Y');
    $sql_ventas_estaciones = "SELECT
        CASE
            WHEN MONTH(fecha_registro) IN (12, 1, 2) THEN 'Verano'
            WHEN MONTH(fecha_registro) IN (3, 4, 5) THEN 'Otoño'
            WHEN MONTH(fecha_registro) IN (6, 7, 8) THEN 'Invierno'
            WHEN MONTH(fecha_registro) IN (9, 10, 11) THEN 'Primavera'
        END AS estacion,
        SUM(CAST(REPLACE(total, '.', '') AS UNSIGNED)) AS total_estacion
    FROM
        reservas
    WHERE
        YEAR(fecha_registro) = $current_year
        AND estado = 'Activo'
        AND (estado_reserva = 'Pagado Online' OR estado_reserva = 'Completado' OR estado_reserva = 'Finalizado')
    GROUP BY estacion
    ORDER BY FIELD(estacion, 'Verano', 'Otoño', 'Invierno', 'Primavera')";
    $result_ventas_estaciones = $con->query($sql_ventas_estaciones);
    // Verificar si hubo un error en la consulta
    if (!$result_ventas_estaciones) {
        die("Error en la consulta: " . $con->error);
    }
    // Inicializar un array para almacenar los totales por estación
    $totales_por_estacion = array();
    // Procesar el resultado de la consulta
    if ($result_ventas_estaciones->num_rows > 0) {
        while ($row_estaciones = $result_ventas_estaciones->fetch_assoc()) {
            // El total ya está limpiado en la consulta SQL, así que no es necesario hacer más transformaciones en PHP
            $total_estacion = $row_estaciones['total_estacion'];
            // Almacenar el total en el array con la estación como clave
            $totales_por_estacion[$row_estaciones['estacion']] = $total_estacion;
        }
    } else {
        echo "0 results";
    }

    

?>


<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- loader-->
  <link href="assets/css/pace.min.css" rel="stylesheet" />
  <script src="assets/js/pace.min.js"></script>

  <!--plugins-->
  <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />

  <!-- CSS Files -->
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

  <!--Theme Styles-->
  <link href="assets/css/dark-theme.css" rel="stylesheet" />
  <link href="assets/css/semi-dark.css" rel="stylesheet" />
  <link href="assets/css/header-colors.css" rel="stylesheet" />
  <!-- CSS de SweetAlert2 PARA LA ALERTA ANIMADA CADA VEZ QUE SE REALIZA EDITAR, ELIMINAR ETC. -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.min.css">
    <!-- JS de SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

  <title><?php echo $titulo_menu;  ?></title>
</head>

<body>


  <!--start wrapper-->
  <div class="wrapper">

    <?php include("menu_vector.php");  ?>


    <!-- start page content wrapper-->
    <div class="page-content-wrapper">
      <!-- start page content-->
      <div class="page-content">

        <!--start breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0 align-items-center">
                <li class="breadcrumb-item"><a href="javascript:;">
                    <ion-icon name="home-outline"></ion-icon>
                  </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
              </ol>
            </nav>
          </div>
          
        </div>
        <!--end breadcrumb-->


        <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-4">
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Cantidad de Habitaciones</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-purple">
                    <ion-icon name="wallet-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $countalumnos  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Cantidad de Reservas</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-info">
                    <ion-icon name="people-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $countapoderados  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Cantidad Clientes</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-danger">
                    <ion-icon name="bag-handle-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $total_matriculas  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Ingresos</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo "$ ".$total_ingresos  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--end row-->


        <div class="row row-cols-1 row-cols-lg-3">
          <div class="col">
            <div class="card radius-10 w-100">
              <div class="card-body">
                  <div class="d-flex align-items-center mb-3">
                      <h6 class="mb-0">Habitaciones con mayores ingresos</h6>
                  </div>
                  <div class="countries-list">
                      <?php 
                      $orden_niveles = 1;
                      while ($row = mysqli_fetch_assoc($query)) {
                          $total_ingresos_formateado = number_format($row['total_ingresos'], 0, '', '.');
                      ?>
                          <div class="d-flex align-items-center gap-3 mb-3">
                              <div class="country-icon">
                                  <img src="chile_icon.jpg" alt="" width="35">
                              </div>
                              <div class="country-name flex-grow-1">
                                  <h5 class="mb-0"><?php echo "$ " . $total_ingresos_formateado; ?></h5>
                                  <p class="mb-0 text-secondary"><?php echo $row['nombre_habitacion'] . ' ' . $row['numero']; ?></p>
                              </div>
                              <div class="">
                                  <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><span><?php echo $orden_niveles; ?></span></p>
                              </div>
                          </div>
                      <?php  
                          $orden_niveles++;
                      }  
                      ?>
                  </div>
              </div>
            </div>
          </div>
          
          <!--<div class="col">
            <div class="card radius-10">
                <?php

                // Consulta SQL ajustada
                $sql_graficoingresos = "
                    SELECT 
                        DATE_FORMAT(fecha_registro, '%Y-%m') as mes,
                        SUM(REPLACE(total, '.', '')) as total_ingresos 
                    FROM 
                        reservas 
                    WHERE 
                        estado_reserva = 'Pagado Online'
                    GROUP BY 
                        mes
                    ORDER BY 
                        mes DESC
                    LIMIT 12
                ";

                $query_graficoingresos = $con->query($sql_graficoingresos);
                $datos_grafico = [];
                while ($row = mysqli_fetch_assoc($query_graficoingresos)) {
                    $row['total_ingresos'] = number_format($row['total_ingresos'], 0, '', '.');
                    $datos_grafico[] = $row;
                }
                ?>

                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <h6 class="mb-0">Total Earning</h6>
                    </div>
                    <div class="d-flex align-items-center gap-2 mb-3">
                        <h2 class="mb-0">68%</h2>
                        <div class="">
                            <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6">
                                <i class='bx bx-up-arrow-alt'></i><span>25%</span>
                            </p>
                        </div>
                    </div>
                    <div id="chart1"></div>
                    <div class="mt-4">
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <div class="widget-icon-small rounded bg-light-success text-success">
                                <ion-icon name="wallet-outline"></ion-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">$545.69</h6>
                                <p class="mb-0 text-secondary">Last Month Sales</p>
                            </div>
                            <div class="">
                                <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6">
                                    <i class='bx bx-up-arrow-alt'></i><span>35%</span>
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <div class="widget-icon-small rounded bg-light-tiffany text-tiffany">
                                <ion-icon name="flag-outline"></ion-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">$956.34</h6>
                                <p class="mb-0 text-secondary">Last Month Sales</p>
                            </div>
                            <div class="">
                                <p class="mb-0 text-danger d-flex gap-1 align-items-center fw-500 fs-6">
                                    <i class='bx bx-up-arrow-alt'></i><span>45%</span>
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-3">
                            <div class="widget-icon-small rounded bg-light-danger text-danger">
                                <ion-icon name="school-outline"></ion-icon>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">$6956.48</h6>
                                <p class="mb-0 text-secondary">Last Year Sales</p>
                            </div>
                            <div class="">
                                <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6">
                                    <i class='bx bx-up-arrow-alt'></i><span>66%</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
          </div>-->

        
<script>
// Datos del gráfico desde PHP
var datosGrafico = <?php echo json_encode($datos_grafico); ?>;

// Configuración del gráfico
var opcionesGrafico = {
    series: [{
        name: 'Ingresos Totales',
        data: datosGrafico.map(item => parseInt(item.total_ingresos.replace('.', '')))
    }],
    chart: {
        type: 'bar',
        height: 350
    },
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '55%',
            endingShape: 'rounded'
        },
    },
    xaxis: {
        categories: datosGrafico.map(item => item.mes),
    },
    yaxis: {
        title: {
            text: '$ (ingresos)'
        }
    },
    fill: {
        opacity: 1
    },
    tooltip: {
        y: {
            formatter: function(val) {
                return "$ " + val.toLocaleString();
            }
        }
    }
};

// Renderizar el gráfico
var chart = new ApexCharts(document.querySelector("#chart1"), opcionesGrafico);
chart.render();
</script>



          <!--<div class="col">
            <div class="card radius-10 overflow-hidden w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Total Traffic</h6>
                  
                </div>
                <div class="d-flex align-items-center font-13 gap-2">
                  <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1 text-tiffany"></i>Cliks</span>
                  <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1 text-success"></i>Views</span>
                </div>
                <div id="chart2"></div>
              </div>
            </div>
          </div>-->

          

          <div class="col-8 col-xl-8 d-flex">
              <div class="card radius-10 w-100">
                  <div class="card-body">
                      <div class="d-flex align-items-center mb-3">
                          <h6 class="mb-0">Ganancias por estaciones del año <?php echo $current_year; ?></h6>
                      </div>
                      <div class="row g-4 align-items-center mb-4">
                          

                          <div class="col-12 col-xl-12">
                              <div id="chart30"></div> <!-- Gráfico de ingresos por estación -->
                          </div>
                      </div><!--end row-->
                      <!--<div class="d-flex flex-column flex-lg-row align-items-lg-center align-self-end justify-content-lg-between border p-3 gap-3 mb-0 rounded-3">
                          <div class="d-flex align-items-center gap-3">
                              <div class="widget-icon rounded-circle bg-light-success text-success">
                                  <ion-icon name="card-outline"></ion-icon>
                              </div>
                              <div>
                                  <h4 class="mb-0" id="total-esporadicos">$95,286.50</h4>
                                  <p class="mb-0 text-secondary">Esporádicos</p>
                              </div>
                          </div>
                          <div class="vr d-none d-lg-block"></div>
                          <div class="d-flex align-items-center gap-3">
                              <div class="widget-icon rounded-circle bg-light-info text-info">
                                  <ion-icon name="diamond-outline"></ion-icon>
                              </div>
                              <div>
                                  <h4 class="mb-0" id="total-empresas">$58,820</h4>
                                  <p class="mb-0 text-secondary">Empresas</p>
                              </div>
                          </div>
                          <div class="vr d-none d-lg-block"></div>
                          <div class="d-flex align-items-center gap-3">
                              <div class="widget-icon rounded-circle bg-light-purple text-purple">
                                  <ion-icon name="people-circle-outline"></ion-icon>
                              </div>
                              <div>
                                  <h4 class="mb-0" id="total-turistas">$26,498</h4>
                                  <p class="mb-0 text-secondary">Turistas</p>
                              </div>
                          </div>
                      </div>-->
                  </div>
              </div>
          </div>
        </div>
        <!--end row-->

        <div class="row">
          <div class="col-12 col-xl-12 d-flex">
            <div class="card radius-10 w-100">
              <div class="card-body">
                   <div class="d-flex align-items-center mb-3">
                      <h6 class="mb-0">Ganancias del año <?php echo $current_year; ?></h6>
                      
                   </div>
                   <div class="row g-4 align-items-center mb-4">
                      <div class="col-12 col-xl-4">
                         <div class="d-flex align-items-center gap-2 mb-3">
                             <h1 class="mb-0" id="total-ingresos">$856</h1>
                             <!--<p class="mb-0 text-success bg-light-success px-2 rounded py-1">+10.6%</p>-->
                         </div>
                         <p class="mb-0">Total Ingresos de Enero a Diciembre de las reservas pagadas de todos los tipos de clientes.</p>
                      </div>
                      
                      <div class="col-12 col-xl-8">
                            <div id="chart20"></div> <!-- Primer gráfico -->
                      </div>
                   </div><!--end row-->
                   <div class="d-flex flex-column flex-lg-row align-items-lg-center align-self-end justify-content-lg-between border p-3 gap-3 mb-0 rounded-3">
                    <div class="d-flex align-items-center gap-3">
                      <div class="widget-icon rounded-circle bg-light-success text-success">
                        <ion-icon name="card-outline"></ion-icon>
                      </div>
                      <div class="">
                        <h4 class="mb-0" id="total-esporadicos">$95,286.50</h4>
                        <p class="mb-0 text-secondary">Esporádicos</p>
                      </div>
                    </div>
                    <div class="vr d-none d-lg-block"></div>
                    <div class="d-flex align-items-center gap-3">
                      <div class="widget-icon rounded-circle bg-light-info text-info">
                        <ion-icon name="diamond-outline"></ion-icon>
                      </div>
                      <div class="">
                        <h4 class="mb-0" id="total-empresas">$58,820</h4>
                        <p class="mb-0 text-secondary">Empresas</p>
                      </div>
                    </div>
                    <div class="vr d-none d-lg-block"></div>
                    <div class="d-flex align-items-center gap-3">
                      <div class="widget-icon rounded-circle bg-light-purple text-purple">
                        <ion-icon name="people-circle-outline"></ion-icon>
                      </div>
                      <div class="">
                        <h4 class="mb-0" id="total-turistas">$26,498</h4>
                        <p class="mb-0 text-secondary">Turistas</p>
                      </div>
                    </div>
                  </div>
              </div>
            </div>
          </div>

          <!--<div class="col-12 col-xl-4 d-flex">
            <div class="card radius-10 overflow-hidden w-100">
              <div class="card-body">
                <div class="d-flex flex-column gap-3">
                  <div class="card border shadow-none radius-10 flex-grow-1 mb-0">
                    <div class="card-body">
                      <div class="d-flex align-items-start gap-2">
                        <div>
                          <h5 class="mb-0 ">Total Accounts</h5>
                        </div>
                        <div class="ms-auto widget-icon-2 text-white bg-info rounded-circle">
                          <ion-icon name="people-outline"></ion-icon>
                        </div>
                      </div>
                      <div class="">
                        <h3 class="mb-2">68,542</h3>
                        <div class="d-flex align-items-center gap-2">
                           <div class="widget-icon-small bg-light-danger text-danger">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                           </div>
                           <p class="mb-0">+9% last year</p>
                        </div>
                      </div>
                      <div id="chart4"></div>
                    </div>
                  </div>
                  <div class="card border shadow-none radius-10 mb-0">
                    <div class="card-body">
                      <div class="d-flex align-items-start gap-2">
                        <div><p class="mb-0">Disk Space</p></div>
                        <div class="dropdown options ms-auto">
                          <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                            <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                          </div>
                          <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                            <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                            <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                          </ul>
                        </div>
                      </div>
                      <div class="d-flex align-items-center mt-3">
                       <div>
                         <h4 class="mb-3">48GB</h4>
                         <div class="d-flex align-items-center gap-2">
                          <div class="widget-icon-small bg-light-danger text-danger">
                           <ion-icon name="arrow-down-outline"></ion-icon>
                          </div>
                          <p class="mb-0">+7% last month</p>
                       </div>
                       </div>
                       <div class="ms-auto">
                         <div class="w_chart" id="chart5" data-percent="60">
                           <span class="w_percent"></span>
                         </div>
                       </div>
                      </div>
                    </div>
                   </div>
                </div>
              </div>
            </div>
          </div>-->
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function () {

                var totalEsporadicos = <?php echo json_encode($total_esporadicos); ?>; 
                var totalEmpresas = <?php echo json_encode($total_empresas); ?>; 
                var totalTuristas = <?php echo json_encode($total_turistas); ?>;


    var totalesPorMes = <?php echo json_encode($totales_por_mes); ?>;
    var añoActual = new Date().getFullYear();

    var datos = [
        totalesPorMes[añoActual + '-01'] || 0, // Enero
        totalesPorMes[añoActual + '-02'] || 0, // Febrero
        totalesPorMes[añoActual + '-03'] || 0, // Marzo
        totalesPorMes[añoActual + '-04'] || 0, // Abril
        totalesPorMes[añoActual + '-05'] || 0, // Mayo
        totalesPorMes[añoActual + '-06'] || 0, // Junio
        totalesPorMes[añoActual + '-07'] || 0, // Julio
        totalesPorMes[añoActual + '-08'] || 0, // Agosto
        totalesPorMes[añoActual + '-09'] || 0, // Septiembre
        totalesPorMes[añoActual + '-10'] || 0, // Octubre
        totalesPorMes[añoActual + '-11'] || 0, // Noviembre
        totalesPorMes[añoActual + '-12'] || 0  // Diciembre
    ];

    // Calcular el total de ingresos
    var totalIngresos = parseInt(datos[0]) + parseInt(datos[1]) + parseInt(datos[2]) + parseInt(datos[3]) + parseInt(datos[4]) + parseInt(datos[5]) + parseInt(datos[6]) + parseInt(datos[7]) + parseInt(datos[8]) + parseInt(datos[9]) + parseInt(datos[10]) + parseInt(datos[11]);

    // Formatear el total de ingresos con puntos de mil
    function formatearMonto(monto) { 
        return monto.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."); 
    }
    // Formatear valor con punto decimal 
    var totalIngresosFormateado = formatearMonto(totalIngresos); 
    // Actualizar el valor en el h4 
    document.getElementById('total-ingresos').textContent = '$' + totalIngresosFormateado;
    // Actualizar los valores en los h4 
    document.getElementById('total-esporadicos').textContent = '$' + formatearMonto(totalEsporadicos); 
    document.getElementById('total-empresas').textContent = '$' + formatearMonto(totalEmpresas); 
    document.getElementById('total-turistas').textContent = '$' + formatearMonto(totalTuristas);

    var options = {
        chart: {
            type: 'line', // Tipo de gráfico
            height: 300, // Altura del gráfico
            toolbar: {
                show: false // Ocultar barra de herramientas del gráfico
            }
        },
        series: [{
            name: 'Ingresos',
            data: datos
        }],
        xaxis: {
            categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sept', 'Oct', 'Nov', 'Dic'] // Categorías de eje X
        },
        colors: ['#008FFB'], // Color de la línea del gráfico
        stroke: {
            width: 2
        },
        dataLabels: {
            enabled: false // Ocultar etiquetas de datos
        },
        grid: {
            show: true
        },
        markers: {
            size: 5, // Tamaño de los marcadores
            colors: ['#008FFB'], // Color de los marcadores
            strokeColors: '#fff',
            strokeWidth: 2
        }
    };

    // Inicializar el gráfico en el div con id="chart20"
    var chart20 = new ApexCharts(document.querySelector("#chart20"), options);
    chart20.render(); // Renderizar el gráfico
});

        </script>


        <script>
document.addEventListener('DOMContentLoaded', function() {
    var totalEsporadicos = <?php echo json_encode($total_esporadicos); ?>; 
    var totalEmpresas = <?php echo json_encode($total_empresas); ?>; 
    var totalTuristas = <?php echo json_encode($total_turistas); ?>;

    var totalesPorEstacion = <?php echo json_encode($totales_por_estacion); ?>;
    var datos = [
        totalesPorEstacion['Verano'] || 0,
        totalesPorEstacion['Otoño'] || 0,
        totalesPorEstacion['Invierno'] || 0,
        totalesPorEstacion['Primavera'] || 0
    ];

    // Calcular el total de ingresos
    var totalIngresos = datos.reduce((a, b) => a + parseInt(b), 0);

    // Formatear el total de ingresos con puntos de mil
    function formatearMonto(monto) { 
        return monto.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."); 
    }
    // Formatear valor con punto decimal 
    var totalIngresosFormateado = formatearMonto(totalIngresos); 
    // Actualizar el valor en el h4 
    document.getElementById('total-ingresos').textContent = '$' + totalIngresosFormateado;
    // Actualizar los valores en los h4 
    document.getElementById('total-esporadicos').textContent = '$' + formatearMonto(totalEsporadicos); 
    document.getElementById('total-empresas').textContent = '$' + formatearMonto(totalEmpresas); 
    document.getElementById('total-turistas').textContent = '$' + formatearMonto(totalTuristas);

    var options = {
        chart: {
            type: 'line', // Tipo de gráfico
            height: 300, // Altura del gráfico
            toolbar: {
                show: false // Ocultar barra de herramientas del gráfico
            }
        },
        series: [{
            name: 'Ingresos',
            data: datos
        }],
        xaxis: {
            categories: ['Verano', 'Otoño', 'Invierno', 'Primavera'] // Categorías de eje X
        },
        colors: ['#008FFB'], // Color de la línea del gráfico
        stroke: {
            width: 2
        },
        dataLabels: {
            enabled: false // Ocultar etiquetas de datos
        },
        grid: {
            show: true
        },
        markers: {
            size: 5, // Tamaño de los marcadores
            colors: ['#008FFB'], // Color de los marcadores
            strokeColors: '#fff',
            strokeWidth: 2
        }
    };

    // Inicializar el gráfico en el div con id="chart30"
    var chart30 = new ApexCharts(document.querySelector("#chart30"), options);
    chart30.render(); // Renderizar el gráfico
});
</script>


        <!--end row-->

    

    
      </div>
      <!-- end page content-->
    </div>
    <!--end page content wrapper-->


    <!--start footer-->
    <footer class="footer">
      <div class="footer-text">
        HOSTAL RIBERAS DEL CRUCES. TODOS LOS DERECHOS RESERVADOS. DESARROLLADO POR TRIP GLOBAL 🖥️ ❤️
      </div>
    </footer>
    <!--end footer-->


    <!--Start Back To Top Button-->
    <a href="javaScript:;" class="back-to-top">
      <ion-icon name="arrow-up-outline"></ion-icon>
    </a>
    <!--End Back To Top Button-->

    <!--start switcher-->
  
    <!--end switcher-->


    <!--start overlay-->
    <div class="overlay nav-toggle-icon"></div>
    <!--end overlay-->

  </div>
  <!--end wrapper-->


  <!-- JS Files-->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
  <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
  <!--plugins-->
  <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
  <script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
  <script src="assets/plugins/easyPieChart/jquery.easypiechart.js"></script>
  <script src="assets/plugins/chartjs/chart.min.js"></script>
  <script src="assets/js/index.js"></script>
  <!-- Main JS-->
  <script src="assets/js/main.js"></script>


</body>

</html>